# Sadeem Recruitment API Setup Script
Write-Host "========================================" -ForegroundColor Cyan
Write-Host "Sadeem Recruitment API Setup" -ForegroundColor Cyan
Write-Host "========================================" -ForegroundColor Cyan
Write-Host ""

# Check if .env exists
if (-not (Test-Path ".env")) {
    Write-Host "Creating .env file..." -ForegroundColor Yellow
    Copy-Item ".env.example" ".env"
    Write-Host "✓ .env file created" -ForegroundColor Green
} else {
    Write-Host "✓ .env file already exists" -ForegroundColor Green
}

Write-Host ""
Write-Host "Installing Composer dependencies..." -ForegroundColor Yellow
composer install
if ($LASTEXITCODE -eq 0) {
    Write-Host "✓ Dependencies installed" -ForegroundColor Green
} else {
    Write-Host "✗ Failed to install dependencies" -ForegroundColor Red
    exit 1
}

Write-Host ""
Write-Host "Generating application key..." -ForegroundColor Yellow
php artisan key:generate
if ($LASTEXITCODE -eq 0) {
    Write-Host "✓ Application key generated" -ForegroundColor Green
} else {
    Write-Host "✗ Failed to generate key" -ForegroundColor Red
    exit 1
}

Write-Host ""
Write-Host "Creating database..." -ForegroundColor Yellow
if (-not (Test-Path "database/database.sqlite")) {
    New-Item "database/database.sqlite" -ItemType File | Out-Null
    Write-Host "✓ Database file created" -ForegroundColor Green
} else {
    Write-Host "✓ Database file already exists" -ForegroundColor Green
}

Write-Host ""
Write-Host "Running migrations..." -ForegroundColor Yellow
php artisan migrate --force
if ($LASTEXITCODE -eq 0) {
    Write-Host "✓ Migrations completed" -ForegroundColor Green
} else {
    Write-Host "✗ Migrations failed" -ForegroundColor Red
    exit 1
}

Write-Host ""
Write-Host "Seeding database..." -ForegroundColor Yellow
php artisan db:seed
if ($LASTEXITCODE -eq 0) {
    Write-Host "✓ Database seeded" -ForegroundColor Green
} else {
    Write-Host "✗ Seeding failed" -ForegroundColor Red
    exit 1
}

Write-Host ""
Write-Host "========================================" -ForegroundColor Cyan
Write-Host "Setup Complete!" -ForegroundColor Green
Write-Host "========================================" -ForegroundColor Cyan
Write-Host ""
Write-Host "Default Admin Credentials:" -ForegroundColor Yellow
Write-Host "  Email: ahmad@sadeemdubai.ae" -ForegroundColor White
Write-Host "  Password: 123456" -ForegroundColor White
Write-Host ""
Write-Host "To start the server, run:" -ForegroundColor Yellow
Write-Host "  php artisan serve" -ForegroundColor White
Write-Host ""
Write-Host "API will be available at:" -ForegroundColor Yellow
Write-Host "  http://localhost:8000/api" -ForegroundColor White
Write-Host ""
Write-Host "Laravel Telescope dashboard:" -ForegroundColor Yellow
Write-Host "  http://localhost:8000/telescope" -ForegroundColor White
Write-Host ""
