<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\FormConfigController;
use App\Http\Controllers\Api\FormController;
use App\Http\Controllers\Api\Admin\AuthController;
use App\Http\Controllers\Api\Admin\ResponseController;
use App\Http\Controllers\Api\Admin\FormConfigController as AdminFormConfigController;
use App\Http\Controllers\Api\Admin\InterviewsController;

// Public routes
// 1. Get form configuration
Route::get('/form-config', [FormConfigController::class, 'getConfig']);

// 2. Submit form
Route::post('/form-submit', [FormController::class, 'submit']);

// 3. Admin login
Route::post('/admin/login', [AuthController::class, 'login']);

// WhatsApp webhook routes (no authentication required for Meta to access)
Route::get('/webhooks/whatsapp', [InterviewsController::class, 'verifyWebhook']);
Route::post('/webhooks/whatsapp', [InterviewsController::class, 'handleWebhook']);

// Protected admin routes
Route::prefix('admin')->middleware('auth:sanctum')->group(function () {
    // Logout
    Route::post('/logout', [AuthController::class, 'logout']);
    
    // 4. Get all form responses
    Route::get('/responses', [ResponseController::class, 'index']);
    
    // Get single response by ID
    Route::get('/responses/{id}', [ResponseController::class, 'show']);
    
    // 5. Mark single response as viewed
    Route::patch('/responses/{id}/viewed', [ResponseController::class, 'markViewed']);
    
    // 6. Bulk mark responses as viewed
    Route::patch('/responses/bulk-viewed', [ResponseController::class, 'bulkMarkViewed']);
    
    // 7. Update form configuration
    Route::put('/form-config', [AdminFormConfigController::class, 'update']);
    
    // Interview management routes
    Route::get('/interviews', [InterviewsController::class, 'index']);
    Route::post('/interviews', [InterviewsController::class, 'store']);
    Route::get('/interviews/{id}', [InterviewsController::class, 'show']);
    Route::put('/interviews/{id}', [InterviewsController::class, 'update']);
    Route::delete('/interviews/{id}', [InterviewsController::class, 'destroy']);
    Route::put('/interviews/{id}/candidate-status', [InterviewsController::class, 'updateCandidateStatus']);
    Route::put('/interviews/{id}/status', [InterviewsController::class, 'updateStatus']);
    
    // Schedule interview with WhatsApp notification
    Route::post('/schedule', [InterviewsController::class, 'schedule']);
    
    // WhatsApp messages
    Route::get('/whatsapp/messages', [InterviewsController::class, 'getMessages']);
    
    // Customer profile (all data by phone number)
    Route::get('/customer-profile', [InterviewsController::class, 'getCustomerProfile']);
    
    // Chat conversations list
    Route::get('/chat/conversations', [InterviewsController::class, 'getConversations']);
    
    // Get messages for a specific conversation
    Route::get('/chat/messages', [InterviewsController::class, 'getChatMessages']);
    
    // Send a text message in chat
    Route::post('/chat/send', [InterviewsController::class, 'sendChatMessage']);
});
