<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\FormConfig;
use App\Models\FormResponse;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    use WithoutModelEvents;

    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // Create admin user
        User::create([
            'name' => 'Ahmad',
            'email' => 'ahmad@sadeemdubai.ae',
            'password' => bcrypt('123456'),
            'role' => 'admin',
        ]);

        // Create initial form configuration
        FormConfig::create([
            'whatsapp_number' => '971554466467',
            'fields' => [
                [
                    'id' => 'name',
                    'label' => 'Full Name',
                    'type' => 'text',
                    'enabled' => true,
                    'required' => true,
                    'placeholder' => 'Enter your full name',
                ],
                [
                    'id' => 'phone',
                    'label' => 'Phone Number',
                    'type' => 'tel',
                    'enabled' => true,
                    'required' => true,
                    'placeholder' => '+971 XX XXX XXXX',
                ],
                [
                    'id' => 'email',
                    'label' => 'Email Address',
                    'type' => 'email',
                    'enabled' => false,
                    'required' => false,
                    'placeholder' => 'your.email@example.com',
                ],
                [
                    'id' => 'nationality',
                    'label' => 'Nationality',
                    'type' => 'select',
                    'enabled' => true,
                    'required' => true,
                    'placeholder' => 'Select your nationality',
                    'options' => [
                        ['value' => 'Afghan', 'label' => 'Afghan'],
                        ['value' => 'Albanian', 'label' => 'Albanian'],
                        ['value' => 'Algerian', 'label' => 'Algerian'],
                        ['value' => 'American', 'label' => 'American'],
                        ['value' => 'Andorran', 'label' => 'Andorran'],
                        ['value' => 'Angolan', 'label' => 'Angolan'],
                        ['value' => 'Argentinian', 'label' => 'Argentinian'],
                        ['value' => 'Armenian', 'label' => 'Armenian'],
                        ['value' => 'Australian', 'label' => 'Australian'],
                        ['value' => 'Austrian', 'label' => 'Austrian'],
                        ['value' => 'Azerbaijani', 'label' => 'Azerbaijani'],
                        ['value' => 'Bahamian', 'label' => 'Bahamian'],
                        ['value' => 'Bahraini', 'label' => 'Bahraini'],
                        ['value' => 'Bangladeshi', 'label' => 'Bangladeshi'],
                        ['value' => 'Barbadian', 'label' => 'Barbadian'],
                        ['value' => 'Belarusian', 'label' => 'Belarusian'],
                        ['value' => 'Belgian', 'label' => 'Belgian'],
                        ['value' => 'Belizean', 'label' => 'Belizean'],
                        ['value' => 'Beninese', 'label' => 'Beninese'],
                        ['value' => 'Bhutanese', 'label' => 'Bhutanese'],
                        ['value' => 'Bolivian', 'label' => 'Bolivian'],
                        ['value' => 'Bosnian', 'label' => 'Bosnian'],
                        ['value' => 'Brazilian', 'label' => 'Brazilian'],
                        ['value' => 'British', 'label' => 'British'],
                        ['value' => 'Bruneian', 'label' => 'Bruneian'],
                        ['value' => 'Bulgarian', 'label' => 'Bulgarian'],
                        ['value' => 'Burkinabe', 'label' => 'Burkinabe'],
                        ['value' => 'Burmese', 'label' => 'Burmese'],
                        ['value' => 'Burundian', 'label' => 'Burundian'],
                        ['value' => 'Cambodian', 'label' => 'Cambodian'],
                        ['value' => 'Cameroonian', 'label' => 'Cameroonian'],
                        ['value' => 'Canadian', 'label' => 'Canadian'],
                        ['value' => 'Cape Verdean', 'label' => 'Cape Verdean'],
                        ['value' => 'Chadian', 'label' => 'Chadian'],
                        ['value' => 'Chilean', 'label' => 'Chilean'],
                        ['value' => 'Chinese', 'label' => 'Chinese'],
                        ['value' => 'Colombian', 'label' => 'Colombian'],
                        ['value' => 'Congolese', 'label' => 'Congolese'],
                        ['value' => 'Costa Rican', 'label' => 'Costa Rican'],
                        ['value' => 'Croatian', 'label' => 'Croatian'],
                        ['value' => 'Cuban', 'label' => 'Cuban'],
                        ['value' => 'Cypriot', 'label' => 'Cypriot'],
                        ['value' => 'Czech', 'label' => 'Czech'],
                        ['value' => 'Danish', 'label' => 'Danish'],
                        ['value' => 'Djiboutian', 'label' => 'Djiboutian'],
                        ['value' => 'Dominican', 'label' => 'Dominican'],
                        ['value' => 'Dutch', 'label' => 'Dutch'],
                        ['value' => 'Ecuadorian', 'label' => 'Ecuadorian'],
                        ['value' => 'Egyptian', 'label' => 'Egyptian'],
                        ['value' => 'Emirati', 'label' => 'Emirati'],
                        ['value' => 'English', 'label' => 'English'],
                        ['value' => 'Eritrean', 'label' => 'Eritrean'],
                        ['value' => 'Estonian', 'label' => 'Estonian'],
                        ['value' => 'Ethiopian', 'label' => 'Ethiopian'],
                        ['value' => 'Fijian', 'label' => 'Fijian'],
                        ['value' => 'Filipino', 'label' => 'Filipino'],
                        ['value' => 'Finnish', 'label' => 'Finnish'],
                        ['value' => 'French', 'label' => 'French'],
                        ['value' => 'Gabonese', 'label' => 'Gabonese'],
                        ['value' => 'Gambian', 'label' => 'Gambian'],
                        ['value' => 'Georgian', 'label' => 'Georgian'],
                        ['value' => 'German', 'label' => 'German'],
                        ['value' => 'Ghanaian', 'label' => 'Ghanaian'],
                        ['value' => 'Greek', 'label' => 'Greek'],
                        ['value' => 'Grenadian', 'label' => 'Grenadian'],
                        ['value' => 'Guatemalan', 'label' => 'Guatemalan'],
                        ['value' => 'Guinean', 'label' => 'Guinean'],
                        ['value' => 'Guyanese', 'label' => 'Guyanese'],
                        ['value' => 'Haitian', 'label' => 'Haitian'],
                        ['value' => 'Honduran', 'label' => 'Honduran'],
                        ['value' => 'Hungarian', 'label' => 'Hungarian'],
                        ['value' => 'Icelandic', 'label' => 'Icelandic'],
                        ['value' => 'Indian', 'label' => 'Indian'],
                        ['value' => 'Indonesian', 'label' => 'Indonesian'],
                        ['value' => 'Iranian', 'label' => 'Iranian'],
                        ['value' => 'Iraqi', 'label' => 'Iraqi'],
                        ['value' => 'Irish', 'label' => 'Irish'],
                        ['value' => 'Israeli', 'label' => 'Israeli'],
                        ['value' => 'Italian', 'label' => 'Italian'],
                        ['value' => 'Ivorian', 'label' => 'Ivorian'],
                        ['value' => 'Jamaican', 'label' => 'Jamaican'],
                        ['value' => 'Japanese', 'label' => 'Japanese'],
                        ['value' => 'Jordanian', 'label' => 'Jordanian'],
                        ['value' => 'Kazakh', 'label' => 'Kazakh'],
                        ['value' => 'Kenyan', 'label' => 'Kenyan'],
                        ['value' => 'Kuwaiti', 'label' => 'Kuwaiti'],
                        ['value' => 'Kyrgyz', 'label' => 'Kyrgyz'],
                        ['value' => 'Laotian', 'label' => 'Laotian'],
                        ['value' => 'Latvian', 'label' => 'Latvian'],
                        ['value' => 'Lebanese', 'label' => 'Lebanese'],
                        ['value' => 'Liberian', 'label' => 'Liberian'],
                        ['value' => 'Libyan', 'label' => 'Libyan'],
                        ['value' => 'Lithuanian', 'label' => 'Lithuanian'],
                        ['value' => 'Luxembourgish', 'label' => 'Luxembourgish'],
                        ['value' => 'Macedonian', 'label' => 'Macedonian'],
                        ['value' => 'Malagasy', 'label' => 'Malagasy'],
                        ['value' => 'Malawian', 'label' => 'Malawian'],
                        ['value' => 'Malaysian', 'label' => 'Malaysian'],
                        ['value' => 'Maldivian', 'label' => 'Maldivian'],
                        ['value' => 'Malian', 'label' => 'Malian'],
                        ['value' => 'Maltese', 'label' => 'Maltese'],
                        ['value' => 'Mauritanian', 'label' => 'Mauritanian'],
                        ['value' => 'Mauritian', 'label' => 'Mauritian'],
                        ['value' => 'Mexican', 'label' => 'Mexican'],
                        ['value' => 'Moldovan', 'label' => 'Moldovan'],
                        ['value' => 'Mongolian', 'label' => 'Mongolian'],
                        ['value' => 'Moroccan', 'label' => 'Moroccan'],
                        ['value' => 'Mozambican', 'label' => 'Mozambican'],
                        ['value' => 'Namibian', 'label' => 'Namibian'],
                        ['value' => 'Nepalese', 'label' => 'Nepalese'],
                        ['value' => 'New Zealander', 'label' => 'New Zealander'],
                        ['value' => 'Nicaraguan', 'label' => 'Nicaraguan'],
                        ['value' => 'Nigerian', 'label' => 'Nigerian'],
                        ['value' => 'Nigerien', 'label' => 'Nigerien'],
                        ['value' => 'North Korean', 'label' => 'North Korean'],
                        ['value' => 'Norwegian', 'label' => 'Norwegian'],
                        ['value' => 'Omani', 'label' => 'Omani'],
                        ['value' => 'Pakistani', 'label' => 'Pakistani'],
                        ['value' => 'Palestinian', 'label' => 'Palestinian'],
                        ['value' => 'Panamanian', 'label' => 'Panamanian'],
                        ['value' => 'Paraguayan', 'label' => 'Paraguayan'],
                        ['value' => 'Peruvian', 'label' => 'Peruvian'],
                        ['value' => 'Polish', 'label' => 'Polish'],
                        ['value' => 'Portuguese', 'label' => 'Portuguese'],
                        ['value' => 'Qatari', 'label' => 'Qatari'],
                        ['value' => 'Romanian', 'label' => 'Romanian'],
                        ['value' => 'Russian', 'label' => 'Russian'],
                        ['value' => 'Rwandan', 'label' => 'Rwandan'],
                        ['value' => 'Saudi', 'label' => 'Saudi'],
                        ['value' => 'Scottish', 'label' => 'Scottish'],
                        ['value' => 'Senegalese', 'label' => 'Senegalese'],
                        ['value' => 'Serbian', 'label' => 'Serbian'],
                        ['value' => 'Singaporean', 'label' => 'Singaporean'],
                        ['value' => 'Slovak', 'label' => 'Slovak'],
                        ['value' => 'Slovenian', 'label' => 'Slovenian'],
                        ['value' => 'Somali', 'label' => 'Somali'],
                        ['value' => 'South African', 'label' => 'South African'],
                        ['value' => 'South Korean', 'label' => 'South Korean'],
                        ['value' => 'Spanish', 'label' => 'Spanish'],
                        ['value' => 'Sri Lankan', 'label' => 'Sri Lankan'],
                        ['value' => 'Sudanese', 'label' => 'Sudanese'],
                        ['value' => 'Swedish', 'label' => 'Swedish'],
                        ['value' => 'Swiss', 'label' => 'Swiss'],
                        ['value' => 'Syrian', 'label' => 'Syrian'],
                        ['value' => 'Taiwanese', 'label' => 'Taiwanese'],
                        ['value' => 'Tajik', 'label' => 'Tajik'],
                        ['value' => 'Tanzanian', 'label' => 'Tanzanian'],
                        ['value' => 'Thai', 'label' => 'Thai'],
                        ['value' => 'Tunisian', 'label' => 'Tunisian'],
                        ['value' => 'Turkish', 'label' => 'Turkish'],
                        ['value' => 'Ugandan', 'label' => 'Ugandan'],
                        ['value' => 'Ukrainian', 'label' => 'Ukrainian'],
                        ['value' => 'Uruguayan', 'label' => 'Uruguayan'],
                        ['value' => 'Uzbek', 'label' => 'Uzbek'],
                        ['value' => 'Venezuelan', 'label' => 'Venezuelan'],
                        ['value' => 'Vietnamese', 'label' => 'Vietnamese'],
                        ['value' => 'Welsh', 'label' => 'Welsh'],
                        ['value' => 'Yemeni', 'label' => 'Yemeni'],
                        ['value' => 'Zambian', 'label' => 'Zambian'],
                        ['value' => 'Zimbabwean', 'label' => 'Zimbabwean'],
                    ],
                ],
                [
                    'id' => 'gender',
                    'label' => 'Gender',
                    'type' => 'radio',
                    'enabled' => true,
                    'required' => true,
                    'options' => [
                        ['value' => 'Male', 'label' => 'Male'],
                        ['value' => 'Female', 'label' => 'Female'],
                    ],
                ],
                [
                    'id' => 'position',
                    'label' => 'Position Applied For',
                    'type' => 'radio',
                    'enabled' => true,
                    'required' => true,
                    'options' => [
                        ['value' => 'Floor Manager', 'label' => 'Floor Manager'],
                        ['value' => 'Head Barista', 'label' => 'Head Barista'],
                        ['value' => 'Executive Pastry Chef', 'label' => 'Executive Pastry Chef'],
                        ['value' => 'Barista', 'label' => 'Barista'],
                        ['value' => 'Waiter/Waitress', 'label' => 'Waiter/Waitress'],
                        ['value' => 'Cashier', 'label' => 'Cashier'],
                    ],
                ],
                [
                    'id' => 'experience',
                    'label' => 'Years of Experience',
                    'type' => 'radio',
                    'enabled' => true,
                    'required' => true,
                    'options' => [
                        ['value' => '0-2 years', 'label' => '0-2 years'],
                        ['value' => '3-5 years', 'label' => '3-5 years'],
                        ['value' => '6-10 years', 'label' => '6-10 years'],
                        ['value' => '10+ years', 'label' => '10+ years'],
                    ],
                ],
                [
                    'id' => 'companies',
                    'label' => 'Previous Companies',
                    'type' => 'textarea',
                    'enabled' => true,
                    'required' => true,
                    'placeholder' => 'List your previous companies...',
                ],
                [
                    'id' => 'salary',
                    'label' => 'Expected Salary (AED)',
                    'type' => 'text',
                    'enabled' => true,
                    'required' => true,
                    'placeholder' => 'e.g., 5000-7000',
                ],
                [
                    'id' => 'in_dubai',
                    'label' => 'Currently in Dubai?',
                    'type' => 'radio',
                    'enabled' => true,
                    'required' => true,
                    'options' => [
                        ['value' => 'Yes', 'label' => 'Yes'],
                        ['value' => 'No', 'label' => 'No'],
                    ],
                ],
                [
                    'id' => 'english_level',
                    'label' => 'English Level',
                    'type' => 'radio',
                    'enabled' => true,
                    'required' => true,
                    'options' => [
                        ['value' => 'basic', 'label' => 'Basic'],
                        ['value' => 'intermediate', 'label' => 'Intermediate'],
                        ['value' => 'fluent', 'label' => 'Fluent'],
                        ['value' => 'native', 'label' => 'Native'],
                    ],
                ],
                [
                    'id' => 'notice_period',
                    'label' => 'Notice Period',
                    'type' => 'radio',
                    'enabled' => true,
                    'required' => true,
                    'options' => [
                        ['value' => 'immediate', 'label' => 'Available to join immediately'],
                        ['value' => '15-30', 'label' => '15-30 days'],
                        ['value' => '30+', 'label' => '30+ days'],
                    ],
                ],
            ],
        ]);

        
    }
}
