<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('whatsapp_messages', function (Blueprint $table) {
            $table->id();
            $table->string('phone', 50)->index();
            $table->string('message_id')->unique();
            $table->enum('direction', ['inbound', 'outbound'])->default('outbound');
            $table->enum('type', ['text', 'template', 'button', 'interactive'])->default('text');
            $table->text('message_body')->nullable();
            $table->json('message_data')->nullable();
            $table->string('status')->nullable()->index();
            $table->foreignId('interview_id')->nullable()->constrained('interviews')->nullOnDelete();
            $table->timestamp('sent_at')->nullable();
            $table->timestamp('delivered_at')->nullable();
            $table->timestamp('read_at')->nullable();
            $table->timestamp('failed_at')->nullable();
            $table->timestamps();
            
            $table->index(['phone', 'created_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('whatsapp_messages');
    }
};
