<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('interviews', function (Blueprint $table) {
            $table->string('whatsapp_message_id')->nullable()->after('status');
            $table->string('whatsapp_status')->nullable()->after('whatsapp_message_id');
            $table->timestamp('whatsapp_sent_at')->nullable()->after('whatsapp_status');
            $table->timestamp('whatsapp_delivered_at')->nullable()->after('whatsapp_sent_at');
            $table->timestamp('whatsapp_read_at')->nullable()->after('whatsapp_delivered_at');
            $table->timestamp('whatsapp_failed_at')->nullable()->after('whatsapp_read_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('interviews', function (Blueprint $table) {
            $table->dropColumn([
                'whatsapp_message_id',
                'whatsapp_status',
                'whatsapp_sent_at',
                'whatsapp_delivered_at',
                'whatsapp_read_at',
                'whatsapp_failed_at',
            ]);
        });
    }
};
