<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('interviews', function (Blueprint $table) {
            $table->id();
            $table->foreignId('response_id')->constrained('form_responses')->onDelete('cascade');
            $table->string('reference_id');
            $table->foreign('reference_id')->references('reference_id')->on('form_responses')->onDelete('cascade');
            $table->string('candidate_name');
            $table->string('phone', 50);
            $table->date('date');
            $table->time('time');
            $table->string('status')->default('pending');
            $table->string('candidate_status')->nullable();
            $table->foreignId('user_id')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamps();

            $table->index('response_id');
            $table->index('date');
            $table->index('status');
            $table->index('candidate_status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('interviews');
    }
};
