<?php

namespace App\Providers;

use Illuminate\Support\Facades\Gate;
use Laravel\Telescope\IncomingEntry;
use Laravel\Telescope\Telescope;
use Laravel\Telescope\TelescopeApplicationServiceProvider;

class TelescopeServiceProvider extends TelescopeApplicationServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        // Telescope::night();

        $this->hideSensitiveRequestDetails();

        Telescope::filter(function (IncomingEntry $entry) {
        // In local/dev: log everything
        if ($this->app->environment('local')) {
            return true;
        }

        // If Telescope is disabled via env, don't log anything
        if (! env('TELESCOPE_ENABLED', false)) {
            return false;
        }

        // In production/staging: only log important stuff
        // return $entry->isReportableException() ||
        //        $entry->isFailedRequest() ||
        //        $entry->isFailedJob() ||
        //        $entry->isScheduledTask() ||
        //        $entry->hasMonitoredTag();
        return true;
    });
    }

    /**
     * Prevent sensitive request details from being logged by Telescope.
     */
    protected function hideSensitiveRequestDetails(): void
    {
        if ($this->app->environment('local')) {
            return;
        }

        Telescope::hideRequestParameters(['_token']);

        Telescope::hideRequestHeaders([
            'cookie',
            'x-csrf-token',
            'x-xsrf-token',
        ]);
    }

    /**
     * Use HTTP Basic Auth for Telescope access.
     */
    public function boot(): void
    {
        parent::boot();

        Telescope::auth(function ($request) {
            // Always allow in local
            if ($this->app->environment('local')) {
                return true;
            }

            // If Telescope is disabled, block access
            if (! env('TELESCOPE_ENABLED', false)) {
                return false;
            }

            $expectedUser = env('TELESCOPE_BASIC_USER');
            $expectedPass = env('TELESCOPE_BASIC_PASSWORD');

            $givenUser = $request->getUser();
            $givenPass = $request->getPassword();

            // Correct credentials → allow
            if ($expectedUser &&
                $expectedPass &&
                $givenUser === $expectedUser &&
                hash_equals($expectedPass, (string) $givenPass)
            ) {
                return true;
            }

            // Wrong / missing credentials → trigger Basic Auth popup
            abort(401, 'Unauthorized', [
                'WWW-Authenticate' => 'Basic realm="Telescope"',
            ]);
        });
    }

    /**
     * Register the Telescope gate.
     *
     * This gate determines who can access Telescope in non-local environments.
     */
    protected function gate(): void
    {
        Gate::define('viewTelescope', function ($user) {
            return in_array($user->email, [
                //add user emails that can access telescope
                'ahmad@sadeemdubai.ae'
            ]);
        });
    }
}
