<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class WhatsAppMessage extends Model
{
    protected $table = 'whatsapp_messages';

    protected $fillable = [
        'phone',
        'message_id',
        'direction',
        'type',
        'message_body',
        'message_data',
        'status',
        'interview_id',
        'sent_at',
        'delivered_at',
        'read_at',
        'failed_at',
    ];

    protected $casts = [
        'message_data' => 'array',
        'sent_at' => 'datetime',
        'delivered_at' => 'datetime',
        'read_at' => 'datetime',
        'failed_at' => 'datetime',
    ];

    /**
     * Get the interview associated with this message
     */
    public function interview(): BelongsTo
    {
        return $this->belongsTo(Interviews::class, 'interview_id');
    }
}
