<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Interviews extends Model
{
    protected $fillable = [
        'response_id',
        'reference_id',
        'candidate_name',
        'phone',
        'date',
        'time',
        'status',
        'candidate_status',
        'user_id',
        'whatsapp_message_id',
        'whatsapp_status',
        'whatsapp_sent_at',
        'whatsapp_delivered_at',
        'whatsapp_read_at',
        'whatsapp_failed_at',
    ];

    protected $casts = [
        'date' => 'date',
        'time' => 'datetime:H:i',
        'whatsapp_sent_at' => 'datetime',
        'whatsapp_delivered_at' => 'datetime',
        'whatsapp_read_at' => 'datetime',
        'whatsapp_failed_at' => 'datetime',
    ];

    /**
     * Get the form response associated with the interview
     */
    public function formResponse(): BelongsTo
    {
        return $this->belongsTo(FormResponse::class, 'response_id');
    }

    /**
     * Get the user (admin) who scheduled/manages the interview
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
