<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class FormConfig extends Model
{
    use HasFactory;

    protected $fillable = [
        'whatsapp_number',
        'fields',
        'updated_by',
    ];

    protected $casts = [
        'fields' => 'array',
    ];

    public function updatedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'updated_by');
    }
}
