<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

class UpdateFormConfigRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'whatsappNumber' => 'required|string|max:50',
            'fields' => 'required|array',
            'fields.*.id' => 'required|string',
            'fields.*.label' => 'required|string|max:255',
            'fields.*.type' => 'required|string|in:text,email,tel,textarea,radio,checkbox,select',
            'fields.*.enabled' => 'required|boolean',
            'fields.*.required' => 'required|boolean',
            'fields.*.placeholder' => 'nullable|string|max:255',
            'fields.*.options' => 'nullable|array',
            'fields.*.options.*.value' => 'required_with:fields.*.options|string',
            'fields.*.options.*.label' => 'required_with:fields.*.options|string',
        ];
    }

    /**
     * Get custom messages for validator errors.
     */
    public function messages(): array
    {
        return [
            'whatsappNumber.required' => 'WhatsApp number is required',
            'fields.required' => 'Fields configuration is required',
            'fields.*.label.required' => 'Label cannot be empty',
            'fields.*.options.*.required' => 'Radio field must have at least one option',
        ];
    }

    /**
     * Handle a failed validation attempt.
     */
    protected function failedValidation(Validator $validator)
    {
        throw new HttpResponseException(
            response()->json([
                'success' => false,
                'error' => 'Validation failed',
                'code' => 'VALIDATION_ERROR',
                'details' => $validator->errors()->toArray(),
            ], 400)
        );
    }
}
