<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

class FormSubmitRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'data' => 'required|array',
            'data.name' => 'nullable|string|max:255',
            'data.phone' => 'nullable|string|max:50',
            'data.email' => 'nullable|email|max:255',
            'data.nationality' => 'nullable|string|max:100',
            'data.gender' => 'nullable|string|in:male,female,Male,Female',
            'data.position' => 'nullable|string|max:255',
            'data.experience' => 'nullable|string|max:50',
            'data.companies' => 'nullable|string',
            'data.salary' => 'nullable|string|max:100',
            'data.in_dubai' => 'nullable|string',
            'data.english_level' => 'nullable|string|max:50',
            'data.notice_period' => 'nullable|string|max:100',
        ];
    }

    /**
     * Get custom messages for validator errors.
     */
    public function messages(): array
    {
        return [
            'data.required' => 'Form data is required',
            'data.phone.required' => 'Invalid phone number format',
            'data.email.email' => 'Invalid email format',
        ];
    }

    /**
     * Handle a failed validation attempt.
     */
    protected function failedValidation(Validator $validator)
    {
        throw new HttpResponseException(
            response()->json([
                'success' => false,
                'error' => 'Validation failed',
                'code' => 'VALIDATION_ERROR',
                'details' => $validator->errors()->toArray(),
            ], 400)
        );
    }
}
