<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\FormConfig;
use Illuminate\Http\JsonResponse;

class FormConfigController extends Controller
{
    /**
     * Get form configuration for public form
     */
    public function getConfig(): JsonResponse
    {
        try {
            $config = FormConfig::latest()->first();

            if (!$config) {
                return response()->json([
                    'success' => false,
                    'error' => 'Configuration not found',
                    'code' => 'CONFIG_NOT_FOUND',
                ], 404);
            }

            return response()->json([
                'success' => true,
                'data' => [
                    'whatsappNumber' => $config->whatsapp_number,
                    'fields' => $config->fields,
                ],
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'error' => 'Failed to fetch configuration',
                'code' => 'CONFIG_FETCH_ERROR',
            ], 500);
        }
    }
}
