# Sadeem Recruitment API

Laravel 12 application with Laravel Telescope for managing recruitment form submissions.

## Features

- ✅ 7 RESTful API endpoints for form management
- ✅ Public form configuration and submission
- ✅ Admin authentication with account locking
- ✅ Form response management with view tracking
- ✅ WhatsApp notification integration
- ✅ Laravel Telescope for debugging
- ✅ Laravel Sanctum for API authentication

## API Endpoints

### Public Endpoints

1. **GET** `/api/form-config` - Get form configuration
2. **POST** `/api/form-submit` - Submit recruitment form
3. **POST** `/api/admin/login` - Admin authentication

### Protected Admin Endpoints (Requires Bearer Token)

4. **GET** `/api/admin/responses` - Get all form submissions (with filtering)
5. **PATCH** `/api/admin/responses/{id}/viewed` - Mark single response as viewed
6. **PATCH** `/api/admin/responses/bulk-viewed` - Bulk mark responses as viewed
7. **PUT** `/api/admin/form-config` - Update form configuration

## Installation

### Prerequisites

- PHP 8.2 or higher
- Composer
- SQLite (default) or MySQL/PostgreSQL

### Setup Steps

1. **Install dependencies:**
   ```bash
   composer install
   ```

2. **Copy environment file:**
   ```bash
   copy .env.example .env
   ```

3. **Generate application key:**
   ```bash
   php artisan key:generate
   ```

4. **Run migrations:**
   ```bash
   php artisan migrate
   ```

5. **Seed database:**
   ```bash
   php artisan db:seed
   ```

6. **Start development server:**
   ```bash
   php artisan serve
   ```

## Default Admin Credentials

- **Email:** ahmad@sadeemdubai.ae
- **Password:** 123456

## WhatsApp Configuration

To enable WhatsApp notifications, add these variables to your `.env` file:

```env
WHATSAPP_API_URL=your_whatsapp_api_url
WHATSAPP_API_KEY=your_api_key
WHATSAPP_FROM_NUMBER=your_from_number
```

The application supports WhatsApp Cloud API format. If not configured, messages will be logged instead.

## Laravel Telescope

Access Telescope dashboard at: `http://localhost:8000/telescope`

Telescope is already installed and configured for monitoring:
- API requests
- Database queries
- Jobs & queues
- Logs & exceptions
- Cache operations

## Form Fields Configuration

The default form includes these fields:

- Full Name (text)
- Phone Number (tel)
- Email Address (email) - disabled by default
- Nationality (text)
- Gender (radio)
- Position Applied For (radio)
- Years of Experience (radio)
- Previous Companies (textarea)
- Expected Salary (text)
- Currently in Dubai? (radio)
- English Level (radio)
- Notice Period (radio)

All fields can be enabled/disabled and configured via the admin API.

## API Usage Examples

### Get Form Configuration
```bash
curl -X GET http://localhost:8000/api/form-config
```

### Submit Form
```bash
curl -X POST http://localhost:8000/api/form-submit \
  -H "Content-Type: application/json" \
  -d "{\"data\": {\"name\": \"John Doe\", \"phone\": \"971501234567\", \"position\": \"Barista\"}}"
```

### Admin Login
```bash
curl -X POST http://localhost:8000/api/admin/login \
  -H "Content-Type: application/json" \
  -d "{\"username\": \"ahmad@sadeemdubai.ae\", \"password\": \"123456\"}"
```

### Get Responses (with token)
```bash
curl -X GET "http://localhost:8000/api/admin/responses?limit=50&viewed=false" \
  -H "Authorization: Bearer YOUR_TOKEN"
```

## Security Features

- **Account Locking:** After 5 failed login attempts, accounts are locked for 30 minutes
- **API Token Authentication:** Using Laravel Sanctum
- **CORS Configuration:** Configurable for your frontend domain
- **Rate Limiting:** Built-in Laravel rate limiting

## Database Schema

### Users Table
- id, name, email, password
- role (admin)
- locked_until, failed_login_attempts

### Form Configs Table
- id, whatsapp_number
- fields (JSON)
- updated_by, timestamps

### Form Responses Table
- id, reference_id (unique)
- data (JSON)
- whatsapp_number
- viewed, viewed_at, viewed_by
- timestamps

## Error Codes

- `CONFIG_FETCH_ERROR` - Failed to fetch configuration
- `VALIDATION_ERROR` - Request validation failed
- `SUBMISSION_ERROR` - Form submission failed
- `INVALID_CREDENTIALS` - Login credentials incorrect
- `ACCOUNT_LOCKED` - Account temporarily locked
- `UNAUTHORIZED` - Missing or invalid token
- `TOKEN_EXPIRED` - Token has expired
- `NOT_FOUND` - Resource not found
- `SERVER_ERROR` - Internal server error

## Development

### Run Tests
```bash
php artisan test
```

### Clear Cache
```bash
php artisan cache:clear
php artisan config:clear
php artisan route:clear
```

### View Routes
```bash
php artisan route:list
```

## Production Deployment

1. Set `APP_ENV=production` in `.env`
2. Set `APP_DEBUG=false`
3. Configure proper database
4. Run `php artisan config:cache`
5. Run `php artisan route:cache`
6. Set up queue worker: `php artisan queue:work`

## Code of Conduct

In order to ensure that the Laravel community is welcoming to all, please review and abide by the [Code of Conduct](https://laravel.com/docs/contributions#code-of-conduct).

## Security Vulnerabilities

If you discover a security vulnerability within Laravel, please send an e-mail to Taylor Otwell via [taylor@laravel.com](mailto:taylor@laravel.com). All security vulnerabilities will be promptly addressed.

## License

The Laravel framework is open-sourced software licensed under the [MIT license](https://opensource.org/licenses/MIT).
