# Correct Format for Form Submission

## ❌ INCORRECT (Your Current Format)
```json
{
  "name": "ahmad almutawa",
  "phone": "503830053",
  "nationality": "uae",
  "gender": "male",
  "position": "floor_manager",
  "experience": "10+",
  "companies": "test",
  "salary": "9000",
  "in_dubai": "yes",
  "english_level": "basic",
  "notice_period": "30+"
}
```

## ✅ CORRECT (Wrap in "data" object)
```json
{
  "data": {
    "name": "ahmad almutawa",
    "phone": "503830053",
    "nationality": "uae",
    "gender": "male",
    "position": "floor_manager",
    "experience": "10+",
    "companies": "test",
    "salary": "9000",
    "in_dubai": "yes",
    "english_level": "basic",
    "notice_period": "30+"
  }
}
```

## Why?

The API expects all form fields to be nested inside a `data` property. This is by design according to the API specification you provided.

## How to Test

### Using cURL:
```bash
curl -X POST http://localhost:8000/api/form-submit \
  -H "Content-Type: application/json" \
  -d "{\"data\": {\"name\": \"ahmad almutawa\", \"phone\": \"503830053\", \"nationality\": \"uae\", \"gender\": \"male\", \"position\": \"floor_manager\", \"experience\": \"10+\", \"companies\": \"test\", \"salary\": \"9000\", \"in_dubai\": \"yes\", \"english_level\": \"basic\", \"notice_period\": \"30+\"}}"
```

### Using PowerShell:
```powershell
$body = @{
    data = @{
        name = "ahmad almutawa"
        phone = "503830053"
        nationality = "uae"
        gender = "male"
        position = "floor_manager"
        experience = "10+"
        companies = "test"
        salary = "9000"
        in_dubai = "yes"
        english_level = "basic"
        notice_period = "30+"
    }
} | ConvertTo-Json

Invoke-RestMethod -Uri "http://localhost:8000/api/form-submit" -Method Post -Body $body -ContentType "application/json"
```

### Using Postman:
1. Set Method to `POST`
2. URL: `http://localhost:8000/api/form-submit`
3. Headers: `Content-Type: application/json`
4. Body (raw JSON):
```json
{
  "data": {
    "name": "ahmad almutawa",
    "phone": "503830053",
    "nationality": "uae",
    "gender": "male",
    "position": "floor_manager",
    "experience": "10+",
    "companies": "test",
    "salary": "9000",
    "in_dubai": "yes",
    "english_level": "basic",
    "notice_period": "30+"
  }
}
```

## Expected Success Response:
```json
{
  "success": true,
  "data": {
    "id": "1",
    "referenceId": "12345",
    "timestamp": "2025-11-23T02:45:00Z",
    "whatsappNumber": "971501234567",
    "message": "Form submitted successfully"
  }
}
```
