# API Testing Guide

## Server Status
✅ Server is running at: http://localhost:8000

## Quick Test Commands

### 1. Test Get Form Configuration
```bash
curl http://localhost:8000/api/form-config
```

### 2. Test Form Submission
```bash
curl -X POST http://localhost:8000/api/form-submit -H "Content-Type: application/json" -d "{\"data\": {\"name\": \"John Doe\", \"phone\": \"971501234567\", \"nationality\": \"Filipino\", \"gender\": \"Male\", \"position\": \"Barista\", \"experience\": \"3-5\", \"companies\": \"Starbucks\", \"salary\": \"5000\", \"in_dubai\": \"Yes\", \"english_level\": \"Fluent\", \"notice_period\": \"immediate\"}}"
```

### 3. Test Admin Login
```bash
curl -X POST http://localhost:8000/api/admin/login -H "Content-Type: application/json" -d "{\"username\": \"ahmad@sadeemdubai.ae\", \"password\": \"123456\"}"
```

Copy the token from the response and use it for the following requests:

### 4. Test Get Responses (Replace YOUR_TOKEN)
```bash
curl -X GET "http://localhost:8000/api/admin/responses?limit=50" -H "Authorization: Bearer YOUR_TOKEN"
```

### 5. Test Mark Response as Viewed (Replace YOUR_TOKEN and response ID)
```bash
curl -X PATCH http://localhost:8000/api/admin/responses/1/viewed -H "Authorization: Bearer YOUR_TOKEN" -H "Content-Type: application/json" -d "{\"viewed\": true}"
```

## PowerShell Test Commands

### 1. Get Form Configuration
```powershell
Invoke-RestMethod -Uri "http://localhost:8000/api/form-config" -Method Get
```

### 2. Submit Form
```powershell
$body = @{
    data = @{
        name = "John Doe"
        phone = "971501234567"
        nationality = "Filipino"
        gender = "Male"
        position = "Barista"
        experience = "3-5"
        companies = "Starbucks"
        salary = "5000"
        in_dubai = "Yes"
        english_level = "Fluent"
        notice_period = "immediate"
    }
} | ConvertTo-Json

Invoke-RestMethod -Uri "http://localhost:8000/api/form-submit" -Method Post -Body $body -ContentType "application/json"
```

### 3. Admin Login
```powershell
$loginBody = @{
    username = "ahmad@sadeemdubai.ae"
    password = "123456"
} | ConvertTo-Json

$response = Invoke-RestMethod -Uri "http://localhost:8000/api/admin/login" -Method Post -Body $loginBody -ContentType "application/json"
$token = $response.data.token
Write-Host "Token: $token"
```

### 4. Get Responses (Using token from previous step)
```powershell
$headers = @{
    Authorization = "Bearer $token"
}

Invoke-RestMethod -Uri "http://localhost:8000/api/admin/responses?limit=50" -Method Get -Headers $headers
```

## Access Points

- **API Base URL:** http://localhost:8000/api
- **Telescope Dashboard:** http://localhost:8000/telescope
- **Admin Credentials:**
  - Email: ahmad@sadeemdubai.ae
  - Password: 123456

## Postman Collection

Import the `postman_collection.json` file in the root directory for a complete API testing experience with all endpoints pre-configured.

## All API Endpoints

1. ✅ `GET /api/form-config` - Get form configuration
2. ✅ `POST /api/form-submit` - Submit recruitment form
3. ✅ `POST /api/admin/login` - Admin authentication
4. ✅ `GET /api/admin/responses` - Get all form submissions (Protected)
5. ✅ `PATCH /api/admin/responses/{id}/viewed` - Mark single response as viewed (Protected)
6. ✅ `PATCH /api/admin/responses/bulk-viewed` - Bulk mark responses as viewed (Protected)
7. ✅ `PUT /api/admin/form-config` - Update form configuration (Protected)

## Testing Checklist

- [ ] Get form configuration
- [ ] Submit a form
- [ ] Login as admin
- [ ] View all responses
- [ ] Mark a response as viewed
- [ ] Bulk mark responses as viewed
- [ ] Update form configuration
- [ ] Check Telescope for request tracking
